/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzFS;
import asposewobfuscated.zzP3;
import asposewobfuscated.zzP4;
import asposewobfuscated.zzZ;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.PreferredWidth;
import com.aspose.words.Row;
import com.aspose.words.RowCollection;
import com.aspose.words.Shading;
import com.aspose.words.Style;
import com.aspose.words.zzX;
import com.aspose.words.zzYH;
import com.aspose.words.zzYSW;
import com.aspose.words.zzYX2;
import com.aspose.words.zzYX5;
import com.aspose.words.zzYX7;
import com.aspose.words.zzZFK;
import com.aspose.words.zzZMH;
import com.aspose.words.zzZPL;
import com.aspose.words.zzZXV;
import java.awt.Color;
import java.util.Iterator;

public class Table
extends CompositeNode<Row> {
    private RowCollection zzYeF;
    private zzYX2 zzZwx;

    public Table(DocumentBase doc) {
        super(doc);
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    public Row getFirstRow() {
        Table table = this;
        return (Row)zzX.zzK(table.getFirstChild());
    }

    public Row getLastRow() {
        Table table = this;
        return (Row)zzX.zzJ(table.getLastChild());
    }

    public RowCollection getRows() {
        if (this.zzYeF == null) {
            this.zzYeF = new RowCollection(this);
        }
        return this.zzYeF;
    }

    final boolean zzZkF() {
        for (Row row : this.getRows()) {
            Iterator iterator = row.getCells().iterator();
            if (!iterator.hasNext()) continue;
            iterator.next();
            return true;
        }
        return false;
    }

    @Override
    final Node zzZ(boolean bl, zzZPL zzZPL2) throws Exception {
        Table table = (Table)super.zzZ(bl, zzZPL2);
        if (this.zzZwx != null) {
            table.zzZwx = (zzYX2)this.zzZwx.zzAd();
        }
        table.zzYeF = null;
        return table;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableEnd(this);
    }

    public void ensureMinimum() {
        Row row = this.getFirstRow();
        if (row == null) {
            row = (Row)this.appendChild(new Row(this.getDocument()));
        }
        row.ensureMinimum();
    }

    final Cell zzXS(int n, int n2) {
        try {
            if (n2 < 0 || n2 >= this.getRows().getCount()) {
                return null;
            }
            CellCollection cellCollection = this.getRows().get(n2).getCells();
            if (n < 0 || n >= cellCollection.getCount()) {
                return null;
            }
            return cellCollection.get(n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final int getColumnCount() {
        int n = 0;
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Row row2 = row;
            int n2 = 0;
            Cell cell = row2.getFirstCell();
            while (cell != null) {
                n2 += cell.zzy8().zzzZ();
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZGq();
            }
            n = Math.max(n, n2);
            compositeNode = row;
            row = (Row)compositeNode.zzZGq();
        }
        return n;
    }

    final zzZMH zzZkE() throws Exception {
        zzYX5 zzYX52 = new zzYX5(this);
        return zzYX52.zzZjP();
    }

    final void zzZkD() {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZvH()) {
            Cell cell = null;
            block6: for (Cell cell2 = row.getFirstCell(); cell2 != null; cell2 = cell2.zzya()) {
                switch (cell2.zzy8().getHorizontalMerge()) {
                    case 1: {
                        cell = cell2;
                        cell.zzy8().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 2: {
                        if (cell != null) {
                            Cloneable cloneable;
                            cell.zzy8().setWidth(cell.zzy8().getWidth() + cell2.zzy8().getWidth());
                            cell.zzy8().zzUa(cell.zzy8().zzzZ() + cell2.zzy8().zzzZ());
                            if (cell2.zzy8().getWidth() != 0 && cell.zzy8().getPreferredWidth().zzBN() && cell2.zzy8().getPreferredWidth().zzBN()) {
                                int n = cell.zzy8().getPreferredWidth().zzZxg() + cell2.zzy8().getPreferredWidth().zzZxg();
                                cell.zzy8().setPreferredWidth(PreferredWidth.zzDY(n));
                            }
                            if ((Cell)(cloneable = cell2).zzZGq() == null || ((Cell)(cloneable = cell2).zzZGq()).zzy8().getHorizontalMerge() != 2) {
                                int n = 3140;
                                cloneable = cell2.zzy8();
                                Object object = ((zzFS)cloneable).get(n);
                                if (object != null) {
                                    Object object2 = object;
                                    n = 3140;
                                    cloneable = cell.zzy8();
                                    ((zzFS)cloneable).set(n, object2);
                                } else {
                                    cell.zzy8().remove(3140);
                                }
                            }
                            cell2.remove();
                            cell2 = cell;
                            continue block6;
                        }
                        cell2.zzy8().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 0: {
                        cell = null;
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown cell merge type.");
                    }
                }
            }
        }
    }

    final void zzZkC() throws Exception {
        Object object;
        if (!this.zztJ()) {
            return;
        }
        zzYX7 zzYX72 = new zzYX7(this);
        if (zzYX72.zzwV().length == 0) {
            return;
        }
        zzP4 zzP42 = new zzP4();
        zzP3 zzP32 = new zzP3();
        CompositeNode compositeNode = this.getFirstRow();
        while (compositeNode != null) {
            zzYX72.zzE((Row)compositeNode);
            zzP4 zzP43 = new zzP4();
            zzP3 zzP33 = new zzP3();
            int n = zzYX72.zzZnc();
            Object object2 = ((Row)compositeNode).getFirstCell();
            while (object2 != null) {
                int n2 = zzYX72.zzZk5();
                if (((Cell)object2).zzy8().getVerticalMerge() != 0) {
                    boolean bl;
                    int n3 = zzP42.get(n);
                    if (zzP4.zzY5(n3) || n3 != n2) {
                        ((Cell)object2).zzy8().setVerticalMerge(1);
                    }
                    if (bl = !((Row)compositeNode).zz7P().zzXN(4120) && ((Row)compositeNode).getCells().getCount() == 1) {
                        CompositeNode compositeNode2 = compositeNode;
                        int n4 = ((Row)compositeNode2).getFirstCell().getLastParagraph() != null ? (int)(23.0 * ((Row)compositeNode2).getFirstCell().getLastParagraph().getParagraphBreakFont().getSize()) : 276;
                        zzZXV zzZXV2 = new zzZXV(0, n4);
                        int n5 = 4120;
                        object = ((Row)compositeNode2).zz7P();
                        ((zzFS)object).set(n5, zzZXV2);
                    }
                    zzP43.set(n, n2);
                    zzP33.set(n, object2);
                }
                n += n2;
                object = object2;
                object2 = (Cell)((Node)object).zzZGq();
            }
            object2 = zzP32.zzOH();
            while (((zzP3.zzZ)object2).moveNext()) {
                Cell cell = (Cell)((zzP3.zzZ)object2).zzOF();
                if (cell.zzy8().getVerticalMerge() != 1 || zzP33.get(((zzP3.zzZ)object2).zzOJ()) != null) continue;
                cell.zzy8().setVerticalMerge(0);
            }
            zzP42 = zzP43;
            zzP32 = zzP33;
            object = compositeNode;
            compositeNode = (Row)((Node)object).zzZGq();
        }
        compositeNode = this.getLastRow().getFirstCell();
        while (compositeNode != null) {
            if (((Cell)compositeNode).zzy8().getVerticalMerge() == 1) {
                ((Cell)compositeNode).zzy8().setVerticalMerge(0);
            }
            object = compositeNode;
            compositeNode = (Cell)((Node)object).zzZGq();
        }
    }

    final void zzZkB() throws Exception {
        if (!this.isNested() || this.getFirstRow() == null) {
            return;
        }
        Table table = (Table)this.getAncestor(5);
        boolean bl = table.getAllowAutoFit();
        if (bl != this.getAllowAutoFit()) {
            if (!bl) {
                this.zzZkE();
            }
            this.setAllowAutoFit(bl);
        }
    }

    final int zz90() {
        Row row = this.getFirstRow();
        if (row == null) {
            return 0;
        }
        zzYH zzYH2 = row.getFirstCell().zzy8();
        boolean bl = this.isNested();
        zzYH zzYH3 = zzYH2;
        zzYX2 zzYX22 = row.zz7P();
        return zzYX22.zzZKC() - zzYX22.zzY(zzYH3, bl);
    }

    @Override
    final boolean zzo(Node node) {
        return zzX.zzP(node);
    }

    final boolean isNested() {
        if (this.zzZGu() == null) {
            return false;
        }
        return this.zzZGu().getNodeType() == 7;
    }

    public int getAlignment() {
        return (Integer)this.zzAN(4010);
    }

    public void setAlignment(int value) throws Exception {
        this.zzw(4010, value);
    }

    public boolean getAllowAutoFit() {
        return (Boolean)this.zzAN(4240);
    }

    public void setAllowAutoFit(boolean value) throws Exception {
        this.zzw(4240, value);
    }

    public PreferredWidth getPreferredWidth() {
        return (PreferredWidth)this.zzAN(4230);
    }

    public void setPreferredWidth(PreferredWidth value) throws Exception {
        this.zzw(4230, value);
    }

    public boolean getBidi() {
        return (Boolean)this.zzAN(4380);
    }

    public void setBidi(boolean value) throws Exception {
        this.zzw(4380, value);
    }

    public double getLeftPadding() {
        int n = (Integer)this.zzAN(4020);
        return (double)n / 20.0;
    }

    public void setLeftPadding(double value) throws Exception {
        this.zzw(4020, zzZ.zzU(value));
    }

    public double getRightPadding() {
        int n = (Integer)this.zzAN(4320);
        return (double)n / 20.0;
    }

    public void setRightPadding(double value) throws Exception {
        this.zzw(4320, zzZ.zzU(value));
    }

    public double getTopPadding() {
        int n = (Integer)this.zzAN(4300);
        return (double)n / 20.0;
    }

    public void setTopPadding(double value) throws Exception {
        this.zzw(4300, zzZ.zzU(value));
    }

    public double getBottomPadding() {
        int n = (Integer)this.zzAN(4310);
        return (double)n / 20.0;
    }

    public void setBottomPadding(double value) throws Exception {
        this.zzw(4310, zzZ.zzU(value));
    }

    public double getCellSpacing() {
        int n = (Integer)this.zzAN(4290);
        return (double)n / 20.0;
    }

    public void setCellSpacing(double value) throws Exception {
        this.zzw(4290, zzZ.zzU(value));
    }

    public double getLeftIndent() {
        int n = (Integer)this.zzAN(4340);
        return (double)n / 20.0;
    }

    public void setLeftIndent(double value) throws Exception {
        this.zzw(4340, zzZ.zzU(value));
    }

    public int getStyleOptions() {
        return (Integer)this.zzAN(4140);
    }

    public void setStyleOptions(int value) throws Exception {
        this.zzw(4140, value);
    }

    public Style getStyle() {
        return this.getDocument().getStyles().zzXU(this.zzZX8(), 11);
    }

    public void setStyle(Style value) throws Exception {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("This style belongs to a different document.");
        }
        if (value.getType() != 3) {
            throw new IllegalArgumentException("This style is not a table style.");
        }
        int n = value.zzZX8();
        Table table = this;
        table.zzw(4005, n);
    }

    public String getStyleName() {
        return this.getStyle().getName();
    }

    public void setStyleName(String value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzKz(value));
    }

    public int getStyleIdentifier() {
        return this.getStyle().getStyleIdentifier();
    }

    public void setStyleIdentifier(int value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzB6(value));
    }

    public int getTextWrapping() {
        if (this.isFloating()) {
            return 1;
        }
        return 0;
    }

    public void setTextWrapping(int value) throws Exception {
        if (value == 1) {
            Table table = this;
            zzYX2 zzYX22 = table.getFirstRow().zz7P();
            table.zzw(4160, 2);
            table.zzw(4190, 0);
            table.zzw(4210, 180);
            table.zzw(4270, 180);
            table.zzw(4350, false);
            int n = (Integer)zzYX22.zzUi(4010);
            if (n == 2) {
                table.zzw(4180, 3);
            } else if (n == 1) {
                table.zzw(4180, 2);
            }
            table.zzAP(4010);
            if (zzYX22.contains(4340)) {
                int n2 = 4340;
                zzYX2 zzYX23 = zzYX22;
                int n3 = (Integer)zzYX23.get(n2);
                table.zzw(4170, n3 - 1);
            }
            table.zzAP(4340);
            return;
        }
        Table table = this;
        zzYX2 zzYX24 = table.getFirstRow().zz7P();
        int n = (Integer)zzYX24.zzUi(4180);
        if (n == 3) {
            table.zzw(4010, 2);
        } else if (n == 2) {
            table.zzw(4010, 1);
        }
        table.zzAP(4170);
        table.zzAP(4160);
        table.zzAP(4150);
        table.zzAP(4190);
        table.zzAP(4210);
        table.zzAP(4270);
        table.zzAP(4350);
        table.zzAP(4180);
        table.zzAP(4200);
    }

    final int zzZX8() {
        return (Integer)this.zzAN(4005);
    }

    final boolean isFloating() {
        return this.getRows().getCount() > 0 && this.getRows().get(0).zz7P().isFloating();
    }

    final zzYX2 zz7P() {
        if (this.zzZwx == null) {
            this.zzZwx = new zzYX2();
        }
        return this.zzZwx;
    }

    public void setBorders(int lineStyle, double lineWidth, Color color) throws Exception {
        Iterator iterator = zzYX2.zz2J.zzEy().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.setBorder(n, lineStyle, lineWidth, color, true);
        }
    }

    public void setBorder(int borderType, int lineStyle, double lineWidth, Color color, boolean isOverrideCellBorders) throws Exception {
        if (isOverrideCellBorders) {
            int n = borderType;
            Table table = this;
            switch (n) {
                case 3: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzy8().remove(3110);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZGq();
                    }
                    break;
                }
                case 0: {
                    CompositeNode compositeNode;
                    Row row = table.getLastRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzy8().remove(3130);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZGq();
                    }
                    break;
                }
                case 1: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        if (cell != null) {
                            cell.zzy8().remove(3120);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZGq();
                    }
                    break;
                }
                case 2: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getLastCell();
                        if (cell != null) {
                            cell.zzy8().remove(3140);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZGq();
                    }
                    break;
                }
                case 4: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        boolean bl2 = !row.isFirstRow();
                        bl = !row.isLastRow();
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            if (bl2) {
                                cell.zzy8().remove(3110);
                            }
                            if (bl) {
                                cell.zzy8().remove(3130);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZGq();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZGq();
                    }
                    break;
                }
                case 5: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            boolean bl3;
                            bl = !cell.isFirstCell();
                            boolean bl4 = bl3 = !cell.isLastCell();
                            if (bl) {
                                cell.zzy8().remove(3120);
                            }
                            if (bl3) {
                                cell.zzy8().remove(3140);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZGq();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZGq();
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected border type.");
                }
            }
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZvH()) {
            Border border = row.getRowFormat().getBorders().getByBorderType(borderType);
            border.setLineStyle(lineStyle);
            border.setLineWidth(lineWidth);
            border.setColor(color);
        }
    }

    public void clearBorders() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            int n;
            zzYSW zzYSW2 = row.zz7P();
            Iterator iterator = zzYX2.zz2J.zzEw().iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                zzYSW2.remove(n);
            }
            Cell cell = row.getFirstCell();
            while (cell != null) {
                zzYSW2 = cell.zzy8();
                iterator = zzYH.zz2J.zzEw().iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    zzYSW2.remove(n);
                }
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZGq();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZGq();
        }
    }

    public void setShading(int texture, Color foregroundColor, Color backgroundColor) throws Exception {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                Shading shading = cell.getCellFormat().getShading();
                shading.setTexture(texture);
                shading.setForegroundPatternColor(foregroundColor);
                shading.setBackgroundPatternColor(backgroundColor);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZGq();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZGq();
        }
    }

    public void clearShading() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            zzYSW zzYSW2 = row.zz7P();
            zzYSW2.remove(4330);
            Cell cell = row.getFirstCell();
            while (cell != null) {
                zzYSW2 = cell.zzy8();
                zzYSW2.remove(3170);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZGq();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZGq();
        }
    }

    public void autoFit(int behavior) throws Exception {
        switch (behavior) {
            case 0: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzAP(4230);
                table.zzAO(3020);
                table.zzZkE();
                return;
            }
            case 1: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzw(4230, PreferredWidth.fromPercent(100.0));
                table.zzAO(3020);
                table.zzZkE();
                return;
            }
            case 2: {
                Table table = this;
                table.setAllowAutoFit(false);
                table.setPreferredWidth(PreferredWidth.AUTO);
                Table table2 = table;
                if (table2.zz7P().zzZjm() != null) {
                    table2.zz7P().remove(5106);
                }
                table2 = table;
                Row row = table2.getFirstRow();
                while (row != null) {
                    Cloneable cloneable;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        PreferredWidth preferredWidth;
                        int n = 3010;
                        cloneable = cell.zzy8();
                        Object object = ((zzFS)cloneable).get(n);
                        int n2 = object == null ? 0 : (Integer)object;
                        if (n2 <= 0 && (preferredWidth = cell.getCellFormat().getPreferredWidth()).zzBN()) {
                            n2 = preferredWidth.zzZxg();
                            cell.zzy8().setWidth(n2);
                        }
                        if (n2 <= 0) {
                            n2 = 360 * cell.zzy8().zzzZ();
                            Integer n3 = n2;
                            n = 3010;
                            cloneable = cell.zzy8();
                            ((zzFS)cloneable).set(n, n3);
                        }
                        cell.zzy8().setPreferredWidth(PreferredWidth.zzDY(n2));
                        cloneable = cell;
                        cell = (Cell)cloneable.zzZGq();
                    }
                    cloneable = row;
                    row = (Row)cloneable.zzZGq();
                }
                zzZFK.zzC(table);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown auto fit behavior.");
    }

    final int zzZkA() {
        if (this.getRows().getCount() == 0) {
            return 0;
        }
        int n = 0;
        for (Row row : this.getRows()) {
            int n2 = 0;
            for (Cell cell : row.getCells()) {
                n2 += cell.zzy8().getWidth();
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    final boolean zzZkz() {
        for (Row row : this.getRows()) {
            if (!row.zz7P().hasRevisions()) continue;
            return true;
        }
        return false;
    }

    final void zzAP(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            row.zz7P().remove(n);
            Row row2 = row;
            row = (Row)row2.zzZGq();
        }
    }

    final void zzw(int n, Object object) throws Exception {
        if (this.getFirstRow() == null) {
            throw new IllegalStateException("Formatting cannot be applied because the table is empty. Add at least one row to the table first.");
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZvH()) {
            zzYX2 zzYX22;
            int n2;
            Object object2;
            if (n == 4005) {
                Row row2 = row;
                Table table = this;
                Object object3 = row2.zz7P().get(4120);
                Object object4 = row2.zz7P().get(4240);
                Object object5 = row2.zz7P().get(4230);
                row2.getRowFormat().clearFormatting();
                table.zzAO(3060);
                if (object3 != null) {
                    object2 = object3;
                    n2 = 4120;
                    zzYX22 = row2.zz7P();
                    zzYX22.set(n2, object2);
                }
                if (object4 != null) {
                    object2 = object4;
                    n2 = 4240;
                    zzYX22 = row2.zz7P();
                    zzYX22.set(n2, object2);
                }
                if (object5 != null) {
                    object2 = object5;
                    n2 = 4230;
                    zzYX22 = row2.zz7P();
                    zzYX22.set(n2, object2);
                }
            }
            object2 = object;
            n2 = n;
            zzYX22 = row.zz7P();
            zzYX22.set(n2, object2);
        }
    }

    private void zzAO(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                cell.zzy8().remove(n);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZGq();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZGq();
        }
    }

    private Object zzAN(int n) {
        Row row = this.getFirstRow();
        if (row == null) {
            return zzYX2.zzTQ(n);
        }
        if (n == 4005) {
            if (row.zz7P() != null) {
                return row.zz7P().zzZX8();
            }
            return zzYX2.zzTQ(4005);
        }
        return row.fetchRowAttr(n);
    }
}

