/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzU;
import com.aspose.words.net.System.Data.zzV;
import com.aspose.words.net.System.Data.zzW;
import com.aspose.words.net.System.Data.zzY;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzY4q = new DataRowCollection(this);
    private final DataColumnCollection zzY4p = new DataColumnCollection(this);
    private final ConstraintCollection zzY4o = new ConstraintCollection(this);
    private final zzU zzY4n = new zzU(this);
    private ResultSet zzY4m;
    private String zzZko;
    private DataSet zza4;
    private String zzZbg = "";
    private UniqueConstraint zzY4l;
    private boolean zzY4B = true;
    private final List<DataTableEventListener> zzY4k = new ArrayList<DataTableEventListener>();
    private final Set<DataRow> zzY4j = new HashSet<DataRow>();

    public DataTable() {
    }

    public DataTable(String tableName) {
        this.zzZko = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        this(resultSet, zzY.zzZ(resultSet));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzY4m = resultSet;
        this.zzZko = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzY4m != null) {
            if (this.zzY4m.getStatement() != null) {
                this.zzY4m.getStatement().getConnection().close();
            }
            this.zzY4m = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZko;
    }

    public void setTableName(String tableName) {
        this.zzZko = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzY4p.getCount();
    }

    public String getColumnName(int index) {
        return this.zzY4p.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzY4m;
    }

    public DataSet getDataSet() {
        return this.zza4;
    }

    final void zzZ(DataSet dataSet) {
        this.zza4 = dataSet;
    }

    public DataRowCollection getRows() {
        return this.zzY4q;
    }

    public DataColumnCollection getColumns() {
        return this.zzY4p;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzY4o;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzY4l == null) {
            return new DataColumn[0];
        }
        return this.zzY4l.getColumns();
    }

    final void zzW(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzY4l != null) {
                this.zzY4l.zzRo(false);
                this.getConstraints().remove(this.zzY4l);
                this.zzY4l = null;
            }
            return;
        }
        if (this.zzY4l != null && DataColumn.areColumnSetsTheSame(value, this.zzY4l.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzY4l != null) {
            this.zzY4l.zzRo(false);
            this.getConstraints().remove(this.zzY4l);
            this.zzY4l = null;
        }
        UniqueConstraint.zzZ(this.getConstraints(), uniqueConstraint);
        this.zzY4l = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZbg;
    }

    public void setNamespace(String namespace) {
        this.zzZbg = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzY4B;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzY4B = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzY4j.clear();
            this.getRows().clear();
            this.getColumns().clear();
            DataTable dataTable = this;
            ResultSet resultSet = this.getResultSet();
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                String string = resultSetMetaData.getColumnName(i);
                DataColumn dataColumn = new DataColumn(string, dataTable, i);
                dataColumn.setAllowDBNull(resultSetMetaData.isNullable(i) == 1);
                dataColumn.setAutoIncrement(resultSetMetaData.isAutoIncrement(i));
                dataColumn.setReadOnly(resultSetMetaData.isReadOnly(i));
                try {
                    dataColumn.setDataType(Class.forName(resultSetMetaData.getColumnClassName(i)));
                }
                catch (ClassNotFoundException classNotFoundException) {}
                dataTable.getColumns().add(dataColumn);
            }
            zzY.zzZ(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            sQLException.printStackTrace();
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzY.zzY(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzY4k.contains(listener)) {
            this.zzY4k.add(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzY4k.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzY4j.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzY4k) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzY4j.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzY4k) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzY4j.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzY4k) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    final boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, DataRow dataRow) {
        DataTable dataTable;
        DataRow dataRow2 = dataRow;
        DataColumn[] dataColumnArray3 = dataColumnArray2;
        DataColumn[] dataColumnArray4 = dataColumnArray;
        DataTable dataTable2 = dataTable = this;
        zzV zzV10 = dataTable.zzY4n.zzX(dataColumnArray4);
        return zzV10.zzz8(zzW.zzZ(dataColumnArray3, dataRow2));
    }

    final zzU zzZgg() {
        return this.zzY4n;
    }

    final Set<DataRow> zzZgf() {
        return this.zzY4j;
    }
}

