/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzC2;
import asposewobfuscated.zzC5;
import asposewobfuscated.zzH5;
import asposewobfuscated.zzNJ;
import asposewobfuscated.zzU1;
import asposewobfuscated.zzZ;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.zz4M;
import java.io.EOFException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static zzH5 zzZoY = new zzH5();
    private static zzH5 zzZoX = new zzH5();
    private static zzH5 zzZoW = new zzH5();
    private static zzH5 zzZoV = new zzH5();
    private static zzH5 zzZoU = new zzH5();
    private static zzH5 zzZoT = new zzH5();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzC5 zzC52;
        zzNJ.zzP(fileName, "fileName");
        zzC52 = zzZ.zzU((String)((Object)zzC52));
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz7(zzC52);
            return fileFormatInfo;
        }
        finally {
            ((zzC2)zzC52).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz7(zzZ.zzZ(stream));
    }

    static FileFormatInfo zz7(zzC2 zzC22) throws Exception {
        if (zzC22 == null) {
            throw new IllegalArgumentException("stream");
        }
        try {
            zz4M zz4M2 = new zz4M();
            return zz4M2.zz9(zzC22);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzME(zzU1.zzo(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzMI(zzU1.zzo(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzU1.zzYB(FileFormatUtil.zzMG(loadFormat));
        if (zzNJ.zzZV(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzME(FileFormatUtil.zzMF(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzMI(FileFormatUtil.zzMG(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzU1.zzYB(FileFormatUtil.zzMF(saveFormat));
        if (zzNJ.zzZV(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        String string;
        if (extension == null) {
            throw new IllegalArgumentException("extension");
        }
        return FileFormatUtil.zzMI(zzU1.zzn(string));
    }

    public static String imageTypeToExtension(int imageType) {
        int n;
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        Object object = zzZoW.get(n);
        return "." + zzU1.zzYB(object == null ? 0 : (Integer)object);
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ParseException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzMJ(int n) {
        return zzU1.toString(FileFormatUtil.zzMF(n));
    }

    static int zzMI(int n) {
        Object object = zzZoU.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static int zzMH(int n) {
        Object object = zzZoT.get(n);
        if (object != null) {
            return (Integer)object;
        }
        return 1;
    }

    private static int zzMG(int n) {
        Object object = zzZoY.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzMF(int n) {
        Object object = zzZoX.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzME(int n) {
        Object object = zzZoV.get(n);
        if (object == null) {
            return 255;
        }
        return (Integer)object;
    }

    static {
        Object[] objectArray = new Object[]{11, 10, 10, null, 11, null, 0, null, 12, 11, 11, null, 13, 20, 20, null, 13, null, 254, null, 14, 21, 21, null, 15, 22, 22, null, 16, 23, 23, null, 18, 24, 24, null, 19, 25, 25, null, 20, 26, 26, null, 21, 27, 27, null, 24, 30, 30, null, 17, 31, 31, null, 25, 50, 50, null, 26, 45, null, null, 27, 51, 51, null, 22, 60, 60, null, 23, 61, 61, null, 30, 40, null, null, 38, 47, null, null, 31, 41, null, null, 32, 46, null, null, 35, 42, null, null, 33, 43, null, null, 34, 44, null, null, 28, 52, null, null, 29, 70, 62, null, 36, 71, null, null, 8, 100, null, null, 6, 101, null, 6, 7, 102, null, 7, 5, 104, null, 5, 4, null, null, 4, 3, null, null, 3, 37, 72, null, null, 2, null, null, 2};
        for (int i = 0; i < 148; i += 4) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            Object object3 = objectArray[i + 2];
            Object object4 = objectArray[i + 3];
            if (object2 != null) {
                zzZoU.add((Integer)object, object2);
                zzZoX.add((Integer)object2, object);
            }
            if (object3 != null) {
                if (!zzZoV.contains((Integer)object)) {
                    zzZoV.add((Integer)object, object3);
                }
                zzZoY.add((Integer)object3, object);
            }
            if (object4 == null) continue;
            zzZoT.add((Integer)object, object4);
            zzZoW.add((Integer)object4, object);
        }
    }
}

