/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzBA;
import asposewobfuscated.zzZ;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.zzX;
import com.aspose.words.zzYVR;
import com.aspose.words.zzZPL;
import com.aspose.words.zzZQR;
import com.aspose.words.zzZW6;

public abstract class Node
implements Cloneable {
    private Node zzYPn;
    private Node zzYPm;
    private Node zzYPl;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzY(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYPn == null) {
            return null;
        }
        if (this.zzYPn.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzYPn;
    }

    final CompositeNode zzZGu() {
        if (zzX.zzL(this.getParentNode())) {
            return this.getParentNode().zzZGu();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzYPn == null) {
            return null;
        }
        return this.zzYPn.getDocument();
    }

    final Document zzZGt() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZGs() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zz9p();
    }

    public Node getPreviousSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getFirstChild()) {
            Node node = this;
            return node.zzYPl;
        }
        return null;
    }

    final Node zzZGr() {
        Node node = zzX.zzJ(this.getPreviousSibling());
        if (node == null && zzX.zzL(this.getParentNode())) {
            node = this.getParentNode().zzZGr();
        }
        return node;
    }

    final Node zzZGq() {
        Node node = zzX.zzK(this.getNextSibling());
        if (node == null && zzX.zzL(this.getParentNode())) {
            node = this.getParentNode().zzZGq();
        }
        return node;
    }

    public Node getNextSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getLastChild()) {
            Node node = this;
            return node.zzYPm;
        }
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZGp() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    final boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    final boolean zzZGo() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzX.zzU(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZGn() {
        return this.zzYPm;
    }

    final void zzZs(Node node) {
        this.zzYPm = node;
    }

    final Node zzZGm() {
        return this.zzYPl;
    }

    final void zzZr(Node node) {
        this.zzYPl = node;
    }

    final int zzZGl() {
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        if (zzX.zzQ(this)) {
            return 3;
        }
        if (zzX.zzP(this)) {
            return 4;
        }
        if (zzX.zzO(this)) {
            return 5;
        }
        if (zzX.zzN(this)) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) throws Exception {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zzZPL zzZPL2) throws Exception {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYPn != null) {
            node.zzYPn = this.getDocument().zz8c();
        }
        node.zzYPm = null;
        node.zzYPl = null;
        if (zzZPL2 != null) {
            zzZPL2.zzV(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzV(StringBuilder stringBuilder) {
        zzZ.zzY(stringBuilder, this.getText());
    }

    public Node getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public Node getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZq(Node node) {
        this.zzYPn = node != null ? node : this.getDocument().zz8c();
    }

    final void zzY(DocumentBase documentBase) {
        this.zzYPn = documentBase != null ? documentBase.zz8c() : null;
    }

    final boolean zzZp(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzZGk() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzGX(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzGW(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzUq(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    @Deprecated
    public String toTxt() throws Exception {
        return this.toString(70);
    }

    public String toString(int saveFormat) throws Exception {
        zzZQR zzZQR2;
        int n = saveFormat;
        switch (n) {
            case 50: {
                zzZQR2 = new zzZW6();
                break;
            }
            case 70: {
                zzZQR2 = new zzYVR();
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZQR zzZQR3 = zzZQR2;
        return zzZQR2.zzZD(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZQR zzZQR2;
        SaveOptions saveOptions2 = saveOptions;
        switch (saveOptions2.getSaveFormat()) {
            case 50: {
                zzZQR2 = new zzZW6((HtmlSaveOptions)saveOptions2);
                break;
            }
            case 70: {
                zzZQR2 = new zzYVR((TxtSaveOptions)saveOptions2);
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZQR zzZQR3 = zzZQR2;
        return zzZQR2.zzZD(this);
    }

    final Node zzGV(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzX.zzR(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final boolean zzZo(Node node) {
        Node node2;
        zzBA zzBA2;
        zzBA zzBA3;
        Node node3 = node;
        Node node4 = this;
        if (node4 == null || node3 == null) {
            return false;
        }
        zzBA zzBA4 = Node.zzZn(node4);
        zzBA zzBA5 = zzBA3 = Node.zzZn(node3);
        zzBA zzBA6 = zzBA4;
        Object var13_8 = null;
        while (zzBA6.peek() == zzBA5.peek()) {
            var13_8 = zzBA6.pop();
            zzBA5.pop();
            zzBA2 = zzBA6;
            if (zzBA2.size() != 0 && (zzBA2 = zzBA5).size() != 0) continue;
        }
        if ((node2 = (Node)var13_8) != null) {
            zzBA2 = zzBA4;
            if (zzBA2.size() == 0 || (zzBA2 = zzBA3).size() == 0) {
                zzBA2 = zzBA3;
                boolean bl = zzBA2.size() > 0;
                return bl;
            }
            Object e = zzBA4.peek();
            Object e2 = zzBA3.peek();
            for (Node node5 : ((CompositeNode)node2).getChildNodes()) {
                if (node5 == e) {
                    return true;
                }
                if (node5 != e2) continue;
            }
        }
        return false;
    }

    final boolean isRemoved() {
        return this.getAncestor(1) == null;
    }

    private static zzBA zzZn(Node node) {
        zzBA zzBA2 = new zzBA();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzBA2.push(node2);
        }
        return zzBA2;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

