/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzCT;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.zz0P;
import com.aspose.words.zzX;
import com.aspose.words.zzZ1T;
import com.aspose.words.zzZUO;
import com.aspose.words.zzZVS;
import java.util.Stack;
import java.util.Vector;

public abstract class Node
implements Cloneable {
    private Node zzYYF;
    private Node zzYYE;
    private Node zzYYD;

    protected Node() {
    }

    /*
     * WARNING - void declaration
     */
    protected Node(DocumentBase doc) {
        void var1_1;
        this.zzZ((DocumentBase)var1_1);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYYF == null) {
            return null;
        }
        if (this.zzYYF.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzYYF;
    }

    final CompositeNode zzZMG() {
        if (zzX.zzL(this.getParentNode())) {
            return this.getParentNode().zzZMG();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzYYF == null) {
            return null;
        }
        return this.zzYYF.getDocument();
    }

    final Document zzZMF() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZME() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzdD();
    }

    public Node getPreviousSibling() {
        Node node = this.getParentNode();
        if (node != null && this != node.getFirstChild()) {
            node = this;
            return node.zzYYD;
        }
        return null;
    }

    final Node zzZMD() {
        Node node = zzX.zzJ(this.getPreviousSibling());
        if (node == null && zzX.zzL(this.getParentNode())) {
            node = this.getParentNode().zzZMD();
        }
        return node;
    }

    final Node zzZMC() {
        Node node = zzX.zzK(this.getNextSibling());
        if (node == null && zzX.zzL(this.getParentNode())) {
            node = this.getParentNode().zzZMC();
        }
        return node;
    }

    public Node getNextSibling() {
        Node node = this.getParentNode();
        if (node != null && this != node.getLastChild()) {
            node = this;
            return node.zzYYE;
        }
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZMB() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    final boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    final boolean zzZMA() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzX.zzU(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZMz() {
        return this.zzYYE;
    }

    final void zzZA(Node node) {
        this.zzYYE = node;
    }

    final Node zzZMy() {
        return this.zzYYD;
    }

    final void zzZz(Node node) {
        this.zzYYD = node;
    }

    final int zzZMx() {
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        if (zzX.zzQ(this)) {
            return 3;
        }
        if (zzX.zzP(this)) {
            return 4;
        }
        if (zzX.zzO(this)) {
            return 5;
        }
        if (zzX.zzN(this)) {
            return 6;
        }
        return 7;
    }

    /*
     * WARNING - void declaration
     */
    public Node deepClone(boolean isCloneChildren) throws Exception {
        void var1_1;
        return this.zzZ((boolean)var1_1, null);
    }

    Node zzZ(boolean bl, zzZUO zzZUO2) throws Exception {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYYF != null) {
            node.zzYYF = this.getDocument().zzct();
        }
        node.zzYYE = null;
        node.zzYYD = null;
        if (zzZUO2 != null) {
            zzZUO2.zzU(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    public Node getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public Node getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZy(Node node) {
        this.zzYYF = node != null ? node : this.getDocument().zzct();
    }

    final void zzZ(DocumentBase documentBase) {
        this.zzYYF = documentBase != null ? documentBase.zzct() : null;
    }

    final boolean zzZx(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    int getTextLength() {
        return this.getText().length();
    }

    /*
     * WARNING - void declaration
     */
    public Node nextPreOrder(Node rootNode) {
        void var1_1;
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == var1_1) {
            node = null;
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    public Node previousPreOrder(Node rootNode) {
        void var1_1;
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == var1_1) {
            node2 = null;
        }
        return node2;
    }

    final Node zzI4(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzI3(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzUA(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    @Deprecated
    public String toTxt() throws Exception {
        return this.toString(70);
    }

    public String toString(int saveFormat) throws Exception {
        zzZVS zzZVS2;
        int n = saveFormat;
        switch (n) {
            case 50: {
                zzZVS2 = new zz0P();
                break;
            }
            case 70: {
                zzZVS2 = new zzZ1T();
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZVS zzZVS3 = zzZVS2;
        return zzZVS2.zzZM(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZVS zzZVS2;
        Object object = saveOptions;
        switch (((SaveOptions)object).getSaveFormat()) {
            case 50: {
                zzZVS2 = new zz0P((HtmlSaveOptions)object);
                break;
            }
            case 70: {
                zzZVS2 = new zzZ1T((TxtSaveOptions)object);
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        object = zzZVS2;
        return zzZVS2.zzZM(this);
    }

    final Node zzI2(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzX.zzR(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final boolean zzZw(Node cloneable) {
        Cloneable cloneable2;
        Cloneable cloneable3 = cloneable;
        cloneable = this;
        if (cloneable == null || cloneable3 == null) {
            return false;
        }
        cloneable = Node.zzZv(cloneable);
        cloneable3 = Node.zzZv(cloneable3);
        Cloneable cloneable42 = cloneable3;
        Object object = cloneable;
        Object var5_6 = null;
        while (((Stack)object).peek() == ((Stack)cloneable42).peek()) {
            var5_6 = ((Stack)object).pop();
            ((Stack)cloneable42).pop();
            cloneable2 = object;
            if (((Vector)cloneable2).size() != 0 && ((Vector)(cloneable2 = cloneable42)).size() != 0) continue;
        }
        if ((object = (Node)var5_6) != null) {
            cloneable2 = cloneable;
            if (((Vector)cloneable2).size() == 0 || ((Vector)(cloneable2 = cloneable3)).size() == 0) {
                cloneable2 = cloneable3;
                boolean bl = ((Vector)cloneable2).size() > 0;
                return bl;
            }
            cloneable = ((Stack)cloneable).peek();
            cloneable3 = ((Stack)cloneable3).peek();
            for (Cloneable cloneable42 : ((CompositeNode)object).getChildNodes()) {
                if (cloneable42 == cloneable) {
                    return true;
                }
                if (cloneable42 != cloneable3) continue;
            }
        }
        return false;
    }

    final boolean isRemoved() {
        return this.getAncestor(1) == null;
    }

    private static zzCT zzZv(Node node) {
        zzCT zzCT2 = new zzCT();
        while (node != null) {
            zzCT2.push(node);
            node = node.getParentNode();
        }
        return zzCT2;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

