/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class PdfPermissions {
    public static final int DISALLOW_ALL = 0;
    public static final int ALLOW_ALL = 65535;
    public static final int CONTENT_COPY = 16;
    public static final int CONTENT_COPY_FOR_ACCESSIBILITY = 512;
    public static final int MODIFY_CONTENTS = 8;
    public static final int MODIFY_ANNOTATIONS = 32;
    public static final int FILL_IN = 256;
    public static final int DOCUMENT_ASSEMBLY = 1024;
    public static final int PRINTING = 4;
    public static final int HIGH_RESOLUTION_PRINTING = 2052;
    public static final int length = 10;

    private PdfPermissions() {
    }

    public static String getName(int pdfPermissions) {
        switch (pdfPermissions) {
            case 0: {
                return "DISALLOW_ALL";
            }
            case 65535: {
                return "ALLOW_ALL";
            }
            case 16: {
                return "CONTENT_COPY";
            }
            case 512: {
                return "CONTENT_COPY_FOR_ACCESSIBILITY";
            }
            case 8: {
                return "MODIFY_CONTENTS";
            }
            case 32: {
                return "MODIFY_ANNOTATIONS";
            }
            case 256: {
                return "FILL_IN";
            }
            case 1024: {
                return "DOCUMENT_ASSEMBLY";
            }
            case 4: {
                return "PRINTING";
            }
            case 2052: {
                return "HIGH_RESOLUTION_PRINTING";
            }
        }
        return "Unknown PdfPermissions value.";
    }

    public static Set<String> getNames(int pdfPermissions) {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        if ((0 & pdfPermissions) == 0) {
            hashSet.add("DISALLOW_ALL");
        }
        if ((0xFFFF & pdfPermissions) == 65535) {
            hashSet.add("ALLOW_ALL");
        }
        if ((0x10 & pdfPermissions) == 16) {
            hashSet.add("CONTENT_COPY");
        }
        if ((0x200 & pdfPermissions) == 512) {
            hashSet.add("CONTENT_COPY_FOR_ACCESSIBILITY");
        }
        if ((8 & pdfPermissions) == 8) {
            hashSet.add("MODIFY_CONTENTS");
        }
        if ((0x20 & pdfPermissions) == 32) {
            hashSet.add("MODIFY_ANNOTATIONS");
        }
        if ((0x100 & pdfPermissions) == 256) {
            hashSet.add("FILL_IN");
        }
        if ((0x400 & pdfPermissions) == 1024) {
            hashSet.add("DOCUMENT_ASSEMBLY");
        }
        if ((4 & pdfPermissions) == 4) {
            hashSet.add("PRINTING");
        }
        if ((0x804 & n) == 2052) {
            hashSet.add("HIGH_RESOLUTION_PRINTING");
        }
        return hashSet;
    }

    public static String toString(int pdfPermissions) {
        switch (pdfPermissions) {
            case 0: {
                return "DisallowAll";
            }
            case 65535: {
                return "AllowAll";
            }
            case 16: {
                return "ContentCopy";
            }
            case 512: {
                return "ContentCopyForAccessibility";
            }
            case 8: {
                return "ModifyContents";
            }
            case 32: {
                return "ModifyAnnotations";
            }
            case 256: {
                return "FillIn";
            }
            case 1024: {
                return "DocumentAssembly";
            }
            case 4: {
                return "Printing";
            }
            case 2052: {
                return "HighResolutionPrinting";
            }
        }
        return "Unknown PdfPermissions value.";
    }

    public static int fromName(String pdfPermissionsName) {
        String string;
        if ("DISALLOW_ALL".equals(pdfPermissionsName)) {
            return 0;
        }
        if ("ALLOW_ALL".equals(pdfPermissionsName)) {
            return 65535;
        }
        if ("CONTENT_COPY".equals(pdfPermissionsName)) {
            return 16;
        }
        if ("CONTENT_COPY_FOR_ACCESSIBILITY".equals(pdfPermissionsName)) {
            return 512;
        }
        if ("MODIFY_CONTENTS".equals(pdfPermissionsName)) {
            return 8;
        }
        if ("MODIFY_ANNOTATIONS".equals(pdfPermissionsName)) {
            return 32;
        }
        if ("FILL_IN".equals(pdfPermissionsName)) {
            return 256;
        }
        if ("DOCUMENT_ASSEMBLY".equals(pdfPermissionsName)) {
            return 1024;
        }
        if ("PRINTING".equals(pdfPermissionsName)) {
            return 4;
        }
        if ("HIGH_RESOLUTION_PRINTING".equals(string)) {
            return 2052;
        }
        throw new IllegalArgumentException("Unknown PdfPermissions name.");
    }

    public static int fromNames(Set<String> pdfPermissionsNames) {
        Iterator<String> iterator;
        int n = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n |= PdfPermissions.fromName(string);
        }
        return n;
    }

    public static int[] getValues() {
        return new int[]{0, 65535, 16, 512, 8, 32, 256, 1024, 4, 2052};
    }
}

